
## Script: BCBot
## Version: 1.02 (TCL)
## Release Date: October 4th, 1999
## Author(s): twidge
## Updater: VGrep Network, Inc.
## Requirements: Eggdrop 1.3.x

##	Administrative TCL script to run and maintain
##	channels dedicated to Banner Clicker.


set bb_chan "#Banner"
set bb_chatchan "#BannerChat"
set bb_file "/path/to/bc.zip"
set bb_filetcl "/path/to/bc.tcl"
set bb_getcmd "!bcsend"
set bb_tclgetcmd "!tclsend"
set bb_invcmd "!invite"
set bb_current {
  "Running BC 1.11"
  "Running BC 1.10"
  "Running BC TCL v1.06"
  "I am running bc.tcl v1.05"
}
set bb_old {
  "I am running BC 1.09"
  "I am running BC Beta 1.08 PR2"
  "I am running BC Beta 1.08 PR3"
  "I am running BC Beta 1.08 PR4"
  "I am running BC Beta 1.08 PR5"
  "I am running bc.tcl v1.04"
}
set bb_bannedhosts {
  "www.bannedcash.com"
}


proc bb_vercheck {nick uhost hand text} {
  global bb_chan bb_chatchan bb_current bb_old bb_getcmd bb_tclgetcmd botnick
  if {![onchan $botnick $bb_chatchan] || ![botisop $bb_chatchan]} {return 0}
  if {![onchan $nick $bb_chatchan]} {return 0}
  if {[lsearch -exact $bb_current $text] != -1} {
    if {![isvoice $nick $bb_chatchan]} {
      pushmode $bb_chatchan +v $nick
    }
    if {[onchan $botnick $bb_chan] && [botisop $bb_chan]} {
      putserv "INVITE $nick $bb_chan"
      putlog "BC: Invited $nick to $bb_chan."
    }
  } elseif {[lsearch -exact $bb_old $text] != -1} {
    if {![isvoice $nick $bb_chatchan]} {
      pushmode $bb_chatchan +v $nick
    }
    putlog "BC: $nick is using an outdated version of BC. Informing..."
    puthelp "PRIVMSG $nick :*** Your version of BC is outdated. To upgrade, in the main channel ($bb_chan) type: '$bb_getcmd' for the latest mIRC version and '$bb_tclgetcmd' for the latest TCL version."
  }
}

proc bb_joincheck {nick uhost hand chan} {
  global bb_chan bb_chatchan botnick
  if {$nick == $botnick} {return 0}
  if {[string tolower $chan] == [string tolower $bb_chatchan]} {
    utimer [expr 2 + [rand 25]] [split "bb_checkdelay $nick"]
  } elseif {[string tolower $chan] == [string tolower $bb_chan]} {
    pushmode $chan +v $nick
  }
}

proc bb_invcheck {nick uhost hand chan arg} {
  global bb_chatchan
  bb_joincheck $nick $uhost $hand $bb_chatchan
}

proc bb_checkdelay {nick} {
  global bb_chan bb_chatchan botnick
  if {![onchan $botnick $bb_chatchan] || ![botisop $bb_chatchan]} {return 0}
  if {![isvoice $nick $bb_chatchan] || ![onchan $nick $bb_chan]} {
    putserv "PRIVMSG $nick :!bcver"
  }
}

proc bb_sendfile {nick uhost hand chan arg} {
  global bb_chatchan bb_file bb_filetcl
  if {[string tolower $chan] != [string tolower $bb_chatchan]} {return 0}
  if {[string tolower $arg] == "tcl"} {
    set file "BC (TCL version)"
    set filesend [dccsend $bb_filetcl $nick]
  } else {
    set file "BC (mIRC version)"
    set filesend [dccsend $bb_file $nick]
  }
  switch -exact -- $filesend {
    0 {
      putlog "bc: sending $file to $nick"
      puthelp "NOTICE $nick :Sending $file..."
    }
    1 {
      puthelp "NOTICE $nick :File requests limit exceeded. Please try again later."
    }
    2 {
      puthelp "NOTICE $nick :Unable to open socket."
    }
    3 {
      putlog "BC: Unable to locate '$file' as requested by $nick."
      puthelp "NOTICE $nick :Unable to locate file."
    }
    4 {
      puthelp "NOTICE $nick :Request for $file has been queued. Please wait..."
    }
  }
}

proc bb_sendtcl {nick uhost hand chan arg} {
  bb_sendfile $nick $uhost $hand $chan tcl
}

proc bb_clickkick {nick uhost hand chan text} {
  global bb_chan bb_chatchan
  if {[isop $nick $chan] || [matchattr $hand f|f $chan]} {return 0}
  if {[string tolower $chan] == [string tolower $bb_chatchan]} {
    if {[string match !click* $text]} {
      putserv "KICK $chan $nick :*** Running click requests in $bb_chatchan prohibited."
    }
  } elseif {[string tolower $chan] == [string tolower $bb_chan]} {
    if {[string match "*Tried to run script without agreeing to disclaimer*" $text]} {
      putserv "KICK $chan $nick :In order to proceed, you must agree to the disclaimer (click on window and choose 'I Agree')."
    }
  }
}

proc bb_bannedhost {nick uhost hand chan arg} {
  global bb_bannedhosts bb_chan
  if {[string tolower $chan] != [string tolower $bb_chan]} {return 0}
  if {[isop $nick $chan] || [matchattr $hand f|f $chan]} {return 0}
  if {![botisop $chan]} {return 0}
  set bhost [string tolower [lindex [split $arg] 1]]
  if {[lsearch -exact [string tolower $bb_bannedhosts] $bhost] != -1} {
    putserv "KICK $chan $nick :Requesting '$bhost' is prohibited (host banned)."
    puthelp "NOTICE $nick :Requesting '$bhost' is prohibited (host banned)."
    set bmask *!*[stl [string range $uhost [string first @ $uhost] end]]
    newchanban $chan $bmask banner "Requesting $bhost is prohibited (host banned)." 30
  }
}

proc bb_bannedhost2 {nick uhost hand chan arg} {
  bb_bannedhost $nick $uhost $hand $chan [join [lrange [split $arg] 1 end]]
}

bind notc - * bb_vercheck
bind join - * bb_joincheck
bind pub - $bb_invcmd bb_invcheck
bind pub - $bb_getcmd bb_sendfile
bind pub - $bb_tclgetcmd bb_sendtcl
bind pubm - * bb_clickkick
bind pubm - !click bb_bannedhost
bind pubm - !click2 bb_bannedhost2

putlog "*** BCBot 1.02 successfully loaded."
